#include <hidef.h>					// common defines and macros
#include <mc9s12hy64.h>				// derivative information
#include "cpu.h"						// CPU routines



/**********************************************************
*	CPMU_PBE
*
*	Setup clock module for PLL Bypass, External.  For DEMOHY64
*	using 8MH XTAL, 
*	Core Clk - 8MHz, Bus Clk - 4MHz
**********************************************************/
void CPMU_PBE(void){
	CPMUOSC_OSCE = 1;					// enable ext OSC
	while(!CPMUFLG_UPOSC);			// wait for ext osc to stabilize
	CPMUCLKS_PLLSEL = 0;				// select ext oscillator
}

/**********************************************************
*	CPMU_PEE_8MHz
*
*	Setup clock module for PLL Engaged using externals XTAL
*	For DEMOHY64 w/ 8MHz XTAL - 
*	VCOCLK - 64MHz, Core Clk - 16MHz, Bus Clk - 8MHz
**********************************************************/
void CPMU_PEE_8MHz(void){

	CPMUSYNR =  0x01;					// fVCO = 32MHz
	CPMUREFDIV =  0x80;				// OSC input is 8MHz
	CPMUPOSTDIV = 0x01;				// core clk - 16MHz, bus clk - 8MHz
	
	CPMUOSC_OSCE = 1;					// enable ext OSC
	while(!CPMUFLG_UPOSC || !CPMUFLG_LOCK);
											// wait for ext osc to stabilize and pll to lock
	CPMUFLG = 0xFF;					// clear CMPMU int flags - not needed but good practice
}

/**********************************************************
*	CPMU_PEE_4MHz
*
*	Setup clock module for PLL Engaged using externals XTAL
*	For DEMOHY64 w/ 4MHz XTAL - 
*	VCOCLK - 32MHz, Core Clk - 4MHz, Bus Clk - 4MHz
**********************************************************/
void CPMU_PEE_4MHz(void){

	CPMUSYNR = 0x03;					// fVCO = 32MHz
	CPMUREFDIV = 0x40;				// OSC input is 4MHz
	CPMUPOSTDIV = 0x03;				// core clk - 4MHz, bus clk - 4MHz
	
	CPMUOSC_OSCE = 1;					// enable ext OSC
	while(!CPMUFLG_UPOSC || !CPMUFLG_LOCK);
											// wait for ext osc to stabilize and pll to lock
	CPMUFLG = 0xFF;					// clear CMPMU int flags - not needed but good practice
}											// bus clk = 4MHz


// configure ports for COM demo
void Configure_Ports(void){
	
  //	IRQCR = 0;							// IRQ responds to falling edge
  	
  /**************************
  *
  *	PORTS CONECTED TO LCD 
  *
  **************************/
  	//PULL ENABLES
  	PUCR = 0x03;						// en PTA, PTB pull ups
  	
  	// PORT A
  	PORTA	= ALL_LOW;	   
  	DDRA	= ALL_INPUTS;				// PORTA is input
	
  	// PORT B
  	PORTB	= ALL_LOW;	   
  	DDRB	= ALL_INPUTS;				// PORTB is input 
	
  	// PORT H
  	PTH	= ALL_LOW;	   	 	
  	DDRH	= ALL_INPUTS;				// PTH is output driving low
	
  	// PORT R							// PTR[7:4] only connected to LCD
  	PTR	= ALL_LOW;
  	PTR = 0x08;     						// PTR[7:4] low, PTRp[3:0] high
  	DDRR	= ALL_OUTPUTS;				// PTR is output driving low
	
  	// PORT P
  	PTP	= ALL_LOW;	   
  	DDRP	= ALL_INPUTS;				// PTP is output driving low

  	// PORT T
  	PTT	= ALL_LOW;	   
  	DDRT	= ALL_INPUTS;				// PTT is output driving low

  /**************************
  *
  *	ALTERNATE USE PORTS 
  *
  **************************/
    // PORT S  
//	PPSS 	= ALL_PULLED_DOWN;		// Configure Pull-polarity  
	PERS 	= ALL_PULLS_OFF;			// Enable Pull devices  
	WOMS 	= 0x00;						// wired-or outputs disabled
	PTS 	= ALL_HIGH;					// port data  
	DDRS	= ALL_OUTPUTS;				// port direction
	
  	// PORT U  
	PPSU 	= ALL_PULLED_DOWN;		// Configure Pull-polarity  
	PERU 	= ALL_PULLS_ON;			// Enable Pull devices  
	PTU  	= ALL_LOW;					// port data  
	DDRU 	= ALL_INPUTS ;				// port direction   
  	
  	// PORT V  
	PPSV 	= ALL_PULLED_DOWN;		// Configure Pull-polarity  
	PERV 	= ALL_PULLS_ON;			// Enable Pull devices  
	PTV   = ALL_LOW;					// port data  
	DDRV 	= ALL_INPUTS;				// port direction  

/**********************************************************
*	PORT AD SETUP
*
*	configure port as input w/ pull-ups enabled,  
*	key-wakeup enabled on PT1AD[7:4] for PBSW use
*  NOTE: to use the digital input function the ATDDIEN bit must be set  
*
*	NOTE: ATD port pull-ups are active for both digital and 
*	analog inputs !  
***********************************************************/
	ATDDIEN	= 0x00F0;				   	// enable PT1AD[4,5,6,7] as digital input
	PER1AD 	= ALL_PULLED_UP; 	// Port AD Pull Enable  
	PT1AD 	= ALL_LOW;				// Port AD I/O Register
	DDR1AD 	= ALL_INPUTS;		  // Port AD Data Direction Register
	
	PIE1AD	= 0xF0;					// enable Port AD interrupts on PT1AD[7,6,5,4]
	
}




